/* OSXSpecifics.h
	
	This file and its header represent a one-stop shop for setting up OSX specific things.
	The goal is to only need to call the setup procedure once, and have the function pointers
	available for the rest of the time Frontier is running. I'll hone this down over time,
	but for right now, this is good enough.
	
*/

enum {
	kQDUseDefaultTextRendering 	= 0,			// Sets whatever is specified in system defaults.
												// Currently sets kQDUseTrueTypeScalerGlyphs if nothing is specified.
	kQDUseTrueTypeScalerGlyphs  	= (1 << 0),	// bit 0
	kQDUseCGTextRendering		= (1 << 1),	// bit 1
	kQDUseCGTextMetrics			= (1 << 2),	// bit 2
	kQDSupportedFlags			= kQDUseTrueTypeScalerGlyphs | kQDUseCGTextRendering | kQDUseCGTextMetrics,	kQDDontChangeFlags	= 0xFFFFFFFF	// to request the current state, without changing anything
};



// BSD function prototypes
/*
int	execv( const char *path, char *const argv[] );
*/
typedef int (*execvFuncPtr)( const char*, char **const );


FILE *	 popen(const char *command, const char *type);
typedef FILE *(*BSDpopenFuncPtr)( const char*, const char* );

int	pclose( FILE *stream );
typedef int (*BSDpcloseFuncPtr)( FILE* );

typedef int (*BSDfreadFuncPtr)( void *, size_t, size_t, FILE * );
typedef UInt32 (*QuartzTextPtr)( UInt32 );

void useQDText(int i);


void	InvokeTool( char *toolName );

